package kochModel.visitor;

import lrs.*;
import kochModel.*;
import java.awt.*;
import java.util.*;
import fp.*;

public class PaintColorVisitor implements IKochVisitor<Object,Graphics> {
  
  public static final PaintColorVisitor Singleton = new PaintColorVisitor();
  
  private PaintColorVisitor() {}

  private  IMapAlgo<Koch, Graphics> _mapAlgo = new IMapAlgo<Koch, Graphics>() {
    public boolean apply(Koch host, Graphics... g) {
      host.execute(PaintColorVisitor.this, g);
      return true;
    }
    public void noApply(Graphics... g) {
    }
  };
    
  
  private Random rand = new Random();
  
  private int currentRed = 128;
  private int currentGreen = 128;
  private int currentBlue = 128;
  private int delta = 10;
  
  public Object baseCase(Koch host, Graphics... g) {    
    paint(host, g[0]);
    return null;
  }
  
  public Object inductCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    host.map(_mapAlgo, g);
    return null;
  }
  
  
  private Koch paint(Koch host, Graphics g) {
    g.setColor(new Color(currentRed, currentGreen, currentBlue));
    currentRed = (256+currentRed+rand.nextInt(2*delta)-delta)%256;
    currentGreen = (256+currentGreen+ rand.nextInt(2*delta)-delta)%256;
    currentBlue = (256+currentBlue + rand.nextInt(2*delta)-delta)%256;
    
    g.drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
               (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    return host;
  }
}